/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.Box;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.citizen.MainWindowCitizen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowInteraction
extends AbstractWindowSkeleton {
    public static final String BUTTON_RESPONSE_ID = "response_";
    private final ICitizenDataView citizen;
    private final List<IInteractionResponseHandler> interactions;
    private int currentInteraction = 0;

    public WindowInteraction(ICitizenDataView citizen) {
        super("minecolonies:gui/citizen/windowinteraction.xml", new MainWindowCitizen(citizen));
        this.citizen = citizen;
        this.interactions = citizen.getOrderedInteractions();
    }

    public void onOpened() {
        super.onOpened();
        this.setupInteraction();
    }

    private void setupInteraction() {
        if (this.currentInteraction >= this.interactions.size()) {
            this.close();
            return;
        }
        IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
        Box group = (Box)this.findPaneOfTypeByID("responseOptions", Box.class);
        int y = 0;
        int x = 0;
        Text chatText = (Text)this.findPaneOfTypeByID("chat", Text.class);
        chatText.setTextAlignment(Alignment.TOP_LEFT);
        chatText.setAlignment(Alignment.TOP_LEFT);
        chatText.setText(this.citizen.getName() + ": " + handler.getInquiry().getString());
        int responseIndex = 1;
        for (Component component : handler.getPossibleResponses()) {
            ButtonImage button = new ButtonImage();
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"), false);
            button.setSize(129, 17);
            button.setColors(100);
            button.setPosition(x, y);
            button.setID(BUTTON_RESPONSE_ID + responseIndex);
            button.setTextRenderBox(129, 17);
            button.setTextAlignment(Alignment.MIDDLE);
            button.setText(component);
            group.addChild((Pane)button);
            if ((y += button.getHeight()) + button.getHeight() >= group.getHeight()) {
                y = 0;
                x += 20 + button.getWidth();
            }
            ++responseIndex;
        }
        handler.onWindowOpened(this, this.citizen);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (!this.interactions.isEmpty()) {
            IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
            for (Component component : handler.getPossibleResponses()) {
                if (!component.getString().equals(button.getTextAsString()) || !handler.onClientResponseTriggered(component, (Player)Minecraft.m_91087_().f_91074_, this.citizen, this)) continue;
                ++this.currentInteraction;
                this.setupInteraction();
                return;
            }
        }
    }
}

